package com.jianLing.demo.controller;


import com.jianLing.demo.util.HttpUtils;
import com.jianLing.demo.util.JsonUtil;
import com.jianLing.demo.util.Md5Utils;
import com.jianLing.demo.util.RsaUtil;
import com.jianLing.demo.vo.*;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;

/**
 * 订单
 * <p>出于demo的简单化考虑，此处将业务逻辑直接写在控制层，实际应用中，应当根据自身的框架，将代码置于业务层，并做必要的事务控制</p>
 *
 */
@Controller()
@RequestMapping("/order")
public class OrderController
{

    // 下单地址
    private String placeOrderUrl = "https://api.yoopay.app/api/cash/placeCash";
    // 查单地址
    private String queryOrderUrl = "https://api.yoopay.app/api/cash/queryCash";

    // 商户号
    private String merchno = "merchno";
    // 商户秘钥
    private String secretKey = "secretKey";

    // 商户私钥
    private String privateKey = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQCqblK7uy2VOOpism5cfQr0kMUVetCieSRQLh0PM3ttGNVln6SzfWYPoZZJwOlDjiJb+6VH6CH7MEq/x4/e6UkvNZJwWb7O+Qo/uNVpumHzdEaG9TCdjzb6Dz54Avz9AlDkippmQik8BZS0r8Y3VT10kW+bZpKYjzEP0/GTTeUTPoPwcPECiG4y8rC+YnRqg8+9V27mUXHvHC0h3tn5DpPIngzH7fMeERTG3otEqPfSFAe2vD1cxW+GS3Is3J4T7JUxKStn2PCyfclwy8UZY9sbb0aVgAlXbKM9Vx18eVxzYTLjVrEKlnnFctDrA2HXSZUFBTl6Ty66Wtoug9LAbre1AgMBAAECggEACecfJ4lYvLLx64oyn20kldFTokvgk5A2a/JB/gAfy9cFj0IXb9Z5d68L7H0pEKPRm0aj8+mpD89eiIYv9ePYPMYAHEcarywJTGqQ+/O4fUzkTDMy//SyXRVFq/OAf7MCwETNc+OkQbiRS25rNgvd5kgNFBqBqhun3iOShdyg0t1WxFYEy6Mx3T0c4/tl5STwUFkF7xkuExypMIb/H+K+EoK0x2zSk9nPPr/eBcXfW0vaQS4bHnQbiKOSswN56nPvTEZEkCDo1q3bySsZ5f2xGxj+K0eEIALMWBnOdJ5qQQGhAJufkycNdgD8Gphxnoa2EzL4MableQEYsXqgwRvqgQKBgQDXODKVA84lMLpMQ5pOWznBxw2QhLU3L/FlfBu4o1XBfTXeQatkDSDVpncwW3Nsvr/C+w5VVbkSVt/5YMjs1IUYv+e0LZ+IAYL7QauXI2rsYRKx2oX7e6V17wgXk0LbDABOomwjqLTe/zs3+WiexTttxkT0GNWPIKC5MMCQR1SiBwKBgQDKuYkKIsMO5T89ru41FQPFihkLAwOuFqWmffOOliJe2VZ7SerCprGm4ycIyK2rRA36ttCTSLa3wcP8qCp8rlayNbjN7Gk1oGUgiQQByVx9MidAi0RQCqPtHGqMeHtr7hvqjpakDYlclesWA5WjaJ8N1uHs3k8x5JReIQkGhju5YwKBgEIfQvMjaydj9CjQME1Ym8McS9+V1jMxaKH8Ymv0yrkapf02AdlIa0kYzs+tmSXU6QeXqIyxPJ4U0NVGVhTlKkszUpW52qSnij11rKlPuV8MZ/j6oWVlVK2KFdtgZA72ffWq0zyVbZSBqAkHeIwnHp4YZ0DzjFFf/eFHyDHLqIXrAoGASaOHshTaggioJkHq6YFOs2zsl+FqbsxvM8FAvaSvq4CLN5GsIzTmB1cwELLE0xePdGj/7uBU7v8FsDtt44h4mZeGH9cmiIJQ+baLrBJ29EtJktqD4AddcH4H/iqtupDttxBAjCsWoHkcwgxfSNJyJFbQDnjaj6cWdfLOEn6kJz0CgYAipmEN2u4R2Z5keuNu/tPaw/CEDxI/yS5Cq9/EYCViu29F9D7j30k3qHmLFwjY1wiHK+hQ5hROv3mE/nec+APNRwi0l69iw8ekOGltEfZwh27xdE07w0gekblMyb13/JD7BU8pXVq3miWT/oGVwdZfmVoaaAaxf4WTQ0FGRoIB+g==";
    // 平台公钥
    private String platformPublicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnRxB3lsiSCNkXq2ziH80QIdCqP5IcEH5hg7bJa2SG3oXYr1bYEP7uytu5P1Tv172Dt73nRzQWMZFUvcxbRDM2msdIZhLWRM2PXc1vky9+8xztY0TrseH3m+gWcowvk3xcdWpguTqLPOol9hzTVL+Ye4TVLbBTEL5DXn8wjBvcmsc/PdLCdIlpUr5RGJU6HwpZdOnLVs5R6ZeHfc4yxNmI4xvT6Y87bErcdLWduCh+0t8j9KADR04IzkXcT+G89Ucco/ZDZNu9kkPJANBfCuJPNhemKu5OlwXJLIMergsAOFrVGBL7MggRz2TohRSzbPGpxZGro7BYZgvjtzdkCxm5QIDAQAB";



    /**
     * 构建下单请求参数
     * @param placeOrderParam
     * @return
     */
    @PostMapping("/placeOrder")
    @ResponseBody
    public Object placeOrder(PlaceOrderParam placeOrderParam, HttpServletRequest httpServletRequest)
    {
        StringBuffer url = httpServletRequest.getRequestURL();
        String protocolAndHost = url.delete(url.length() - httpServletRequest.getRequestURI().length(), url.length()).toString();

        ///////////////////////////////
        // 1:省略 验参 步骤
        ///////////////////////////////

        ///////////////////////////////
        // 2:省略 下单入库 步骤
        ///////////////////////////////

        TreeMap<String, Object> reqParams = new TreeMap<>();
        reqParams.put("merchno", merchno);
        reqParams.put("orderId", String.valueOf(System.currentTimeMillis())); // 作为demo，此处直接使用当前毫秒数作为订单号
        reqParams.put("amount", placeOrderParam.getAmount().setScale(2).toString()); // 订单金额必须保留两位小数
        reqParams.put("account", placeOrderParam.getAccount());
        reqParams.put("tradeType", placeOrderParam.getTradeType());
        reqParams.put("cardNo", placeOrderParam.getCardNo());
        reqParams.put("bankName", placeOrderParam.getBankName());
        reqParams.put("depositBank", placeOrderParam.getDepositBank());
        reqParams.put("asyncUrl", protocolAndHost + "/order/asyncCallback");
        reqParams.put("timestamp", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        reqParams.put("timestamp", "20240723190611");
        reqParams.put("attach", placeOrderParam.getAttach());
        reqParams.put("cashType", placeOrderParam.getCashType());
        reqParams.put("requestCurrency", placeOrderParam.getRequestCurrency());
        reqParams.put("apiVersion", placeOrderParam.getApiVersion());


        String toSignStr = HttpUtils.buildParamString(reqParams);
        toSignStr += "&secretKey=" + secretKey;

        // md5生成信息摘要，并转为小写
        String md5Sign = Md5Utils.hash(toSignStr).toLowerCase();

        // 使用RSA2对信息摘要进行签名
        String sign = RsaUtil.sign(md5Sign, privateKey, true);
        reqParams.put("sign", sign);

        String respStr = HttpUtils.sendPost(placeOrderUrl, reqParams);

        if (respStr == null || "".equals(respStr)) {
            ///////////////////////////////
            // 3:网络不可靠因素、服务器报错  等不可预知的原因导致响应为空； 商户根据自身的业务逻辑做相应的处理（例如：发起查单、下单重试等操作）
            ///////////////////////////////
            return "下单响应为空";
        }
        System.out.println("下单响应：" + respStr);

        PlaceOrderResp placeOrderResp = JsonUtil.unmarshal(respStr, PlaceOrderResp.class);
        PlaceOrderResp.ResponseContent responseContent = placeOrderResp.getResponseContent();
        TreeMap<String, Object> respParams = new TreeMap<>();
        respParams.put("code", responseContent.getCode());
        respParams.put("msg", responseContent.getMsg());
        respParams.put("timestamp", responseContent.getTimestamp());
        respParams.put("merchno", responseContent.getMerchno());
        respParams.put("orderId", responseContent.getOrderId());
        respParams.put("orderNo", responseContent.getOrderNo());
        respParams.put("status", responseContent.getStatus());

        toSignStr = HttpUtils.buildParamString(respParams);
        toSignStr += "&secretKey=" +secretKey;
        // md5生成信息摘要，并转为小写
        md5Sign = Md5Utils.hash(toSignStr).toLowerCase();
        // 使用RSA2对信息摘要进行验签
        boolean isVerify = RsaUtil.verify(md5Sign, placeOrderResp.getSign(), platformPublicKey, true);

        if (!isVerify) {
            System.out.println("签名错误");
            return "签名错误:" + respStr;
        }
        if (0 != responseContent.getCode()) {
            ///////////////////////////////
            // 4:省略 根据状态码 结合 商户自身的业务逻辑进行相应的处理（例如：发起查单、下单重试等操作）
            ///////////////////////////////
            System.out.println("下单失败" + respStr);
            return "下单失败" + respStr;
        }

        ///////////////////////////////
        // 5:省略 根据状态码、订单状态 结合 商户自身的业务逻辑进行相应的处理（例如：更新订单状态等操作）
        ///////////////////////////////

        return respStr;
    }


    /**
     * 异步回调通知接口
     * @param callbackParam
     * @return
     */
    @PostMapping("/asyncCallback")
    @ResponseBody
    public Object asyncCallback(CallbackParam callbackParam) {
        ///////////////////////////////
        // 省略 验参 步骤
        ///////////////////////////////

        TreeMap<String, Object> params = new TreeMap<>();
        params.put("timestamp", callbackParam.getTimestamp());
        params.put("orderNo", callbackParam.getOrderNo());
        params.put("merchno", callbackParam.getMerchno());
        params.put("orderId", callbackParam.getOrderId());
        params.put("amount", callbackParam.getAmount());
        params.put("account", callbackParam.getAccount());
        params.put("tradeType", callbackParam.getTradeType());
        params.put("cardNo", callbackParam.getCardNo());
        params.put("bankName", callbackParam.getBankName());
        params.put("depositBank", callbackParam.getDepositBank());
        params.put("attach", callbackParam.getAttach());
        params.put("status", callbackParam.getStatus());

        params.put("apiVersion", callbackParam.getApiVersion());
        params.put("cashType", callbackParam.getCashType());
        params.put("requestCurrency", callbackParam.getRequestCurrency());

        String toSignStr = HttpUtils.buildParamString(params);
        toSignStr += "&secretKey=" + secretKey;

        // md5生成信息摘要，并转为小写
        String md5Sign = Md5Utils.hash(toSignStr).toLowerCase();
        // 使用RSA2对信息摘要进行验签
        boolean isVerify = RsaUtil.verify(md5Sign, callbackParam.getSign(), platformPublicKey, true);

        if (isVerify) {
            ///////////////////////////////
            // 省略 根据订单状态进行订单确认 步骤
            ///////////////////////////////
        }

        System.out.println("异步回调：" + callbackParam + ":::::::::::::" + isVerify) ;

        return isVerify ? "success" : "fail";
    }


    /**
     * 查单 接口
     * @param queryOrderParam
     * @return
     */
    @PostMapping("/queryOrder")
    @ResponseBody
    public Object queryOrder(QueryOrderParam queryOrderParam) {
        ///////////////////////////////
        // 省略 验参 步骤
        ///////////////////////////////

        TreeMap<String, Object> params = new TreeMap<>();
        params.put("merchno", merchno);
        params.put("orderId", queryOrderParam.getOrderId());
        params.put("timestamp", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        params.put("apiVersion", queryOrderParam.getApiVersion());

        String toSignStr = HttpUtils.buildParamString(params);
        toSignStr += "&secretKey=" + secretKey;

        // md5生成信息摘要，并转为小写
        String md5Sign = Md5Utils.hash(toSignStr).toLowerCase();

        // 使用RSA2对信息摘要进行签名
        String sign = RsaUtil.sign(md5Sign, privateKey, true);
        params.put("sign", sign);

        String respStr = HttpUtils.sendPost(queryOrderUrl, params);

        if (respStr == null || "".equals(respStr)) {
            ///////////////////////////////
            // 3:网络不可靠因素、服务器报错  等不可预知的原因导致响应为空； 商户根据自身的业务逻辑做相应的处理（例如：重新发起查单等操作）
            ///////////////////////////////
            return "查单响应为空";
        }

        System.out.println("查单响应：" + respStr);

        QueryOrderResp queryOrderResp = JsonUtil.unmarshal(respStr, QueryOrderResp.class);
        QueryOrderResp.ResponseContent responseContent = queryOrderResp.getResponseContent();
        TreeMap<String, Object> respParams = new TreeMap<>();
        respParams.put("code", responseContent.getCode());
        respParams.put("msg", responseContent.getMsg());
        respParams.put("timestamp", responseContent.getTimestamp());
        respParams.put("orderNo", responseContent.getOrderNo());
        respParams.put("merchno", responseContent.getMerchno());
        respParams.put("orderId", responseContent.getOrderId());
        respParams.put("amount", responseContent.getAmount());
        respParams.put("account", responseContent.getAccount());
        respParams.put("tradeType", responseContent.getTradeType());
        respParams.put("cardNo", responseContent.getCardNo());
        respParams.put("bankName", responseContent.getBankName());
        respParams.put("depositBank", responseContent.getDepositBank());
        respParams.put("attach", responseContent.getAttach());
        respParams.put("status", responseContent.getStatus());
        respParams.put("requestCurrency", responseContent.getRequestCurrency());

        toSignStr = HttpUtils.buildParamString(respParams);
        toSignStr += "&secretKey=" +secretKey;
        // md5生成信息摘要，并转为小写
        md5Sign = Md5Utils.hash(toSignStr).toLowerCase();
        // 使用RSA2对信息摘要进行验签
        boolean isVerify = RsaUtil.verify(md5Sign, queryOrderResp.getSign(), platformPublicKey, true);

        if (!isVerify) {
            System.out.println("签名错误");
            return "签名错误:" + respStr;
        }
        if (0 != responseContent.getCode()) {
            ///////////////////////////////
            // 4:省略 根据状态码 结合 商户自身的业务逻辑进行相应的处理（例如：重新发起查单等操作）
            ///////////////////////////////
            System.out.println("查单失败" + respStr);
            return "查单失败" + respStr;
        }

        ///////////////////////////////
        // 5:省略 根据状态码、订单状态 结合 商户自身的业务逻辑进行相应的处理（例如：更新订单状态等操作）
        ///////////////////////////////

        return respStr;

    }

}
